<?php

define("APP_VERSION", "1.0.2");

require APP . 'Config' . DS . 'functions.php';

if (file_exists(APP . 'Config' . DS . 'database.php')) {
    try {
        // Load all general options.
        App::uses('ClassRegistry', 'Utility');
        $option = ClassRegistry::init('Option');
        $option->load();
    } catch (Exception $ex) {
    }
}


Configure::write('App.installed', file_exists(APP . 'Config' . DS . 'database.php') &&
 (int) Configure::read('Option.installed'));



/**
 * A random string used in security hashing methods.
 */
//Configure::write( 'Security.salt', Configure::read( 'Option.salt' ) );

/**
 * A random numeric string (digits only) used to encrypt/decrypt strings.
 */
//Configure::write( 'Security.cipherSeed', Configure::read( 'Option.cipherSeed' ) );


if (Configure::read('debug') == 2) {
    CakePlugin::load('DebugKit');
}

if (!Configure::read('App.installed')) {
    return false;
}

if (version_compare(APP_VERSION, Configure::read('Option.app_version'), '>')) {
    $version = $option->findByOptionName('app_version');

    $version[ 'Option' ][ 'option_value' ] = APP_VERSION;

    $option->save($version);
    $option->load();
}


/**
 * Turn off all caching application-wide.
 *
 */
$cache_disable = (bool) Configure::read('Option.cache_disable');
Configure::write('Cache.disable', $cache_disable);

/**
 * Set language
 * http://book.cakephp.org/2.0/en/core-libraries/internationalization-and-localization.html
 * http://book.cakephp.org/2.0/en/core-libraries/internationalization-and-localization.html#localization-in-cakephp
 */
Configure::write('Config.language', Configure::read('Option.site_language'));


/*
 * 		'engine' => 'File', //[required]
 * 		'duration' => 3600, //[optional]
 * 		'probability' => 100, //[optional]
 * 		'path' => CACHE, //[optional] use system tmp directory - remember to use absolute path
 * 		'prefix' => 'cake_', //[optional]  prefix every cache file with this string
 * 		'lock' => false, //[optional]  use file locking
 * 		'serialize' => true, //[optional]
 * 		'mask' => 0664, //[optional]
 */

Cache::config('short', array(
    'engine'      => 'File',
    'duration'    => '+1 hours',
    'probability' => 100,
    'path'        => CACHE . 'short' . DS,
    'prefix'      => 'short_'
));

Cache::config('medium', array(
    'engine'      => 'File',
    'duration'    => '+6 hours',
    'probability' => 100,
    'path'        => CACHE . 'medium' . DS,
    'prefix'      => 'medium_'
));

Cache::config('long', array(
    'engine'      => 'File',
    'duration'    => '+1 week',
    'probability' => 100,
    'path'        => CACHE . 'long' . DS,
    'prefix'      => 'long_'
));

Cache::config('ua', array(
    'engine' => 'File',
    'duration' => '+1 year',
    'probability' => 100,
    'path' => CACHE . 'ua' . DS,
));
